# -*- coding: utf-8 -*-
"""
Created on Wed Apr 28 18:21:14 2021

@author: Dyrvik
"""
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.cm as cm
import matplotlib as mpl
import seaborn as sns
import pandas as pd
import os

"""Colourmaps"""
CM_SUBSECTION_GREENS = np.linspace(0.4, 1.0, 1000) 
COLOURS_GREENS = [ cm.Greens(x) for x in CM_SUBSECTION_GREENS ]

CM_SUBSECTION_ORANGES = np.linspace(0.3, 1.0, 1000) 
COLOURS_ORANGES = [ cm.Oranges(x) for x in CM_SUBSECTION_ORANGES ]

"""File handling"""
main_folder_path = os.path.dirname(os.path.abspath(__file__))
main_folder_path = '\\\\?\\' + main_folder_path
data_folder_path = main_folder_path
export_folder_path = main_folder_path
# =============================================================================
# export_folder_name = 'Plots'
# export_folder_path = os.path.join(main_folder_path,export_folder_name)
# if not os.path.exists(export_folder_path):
#     os.mkdir(export_folder_path) # create folder if non-existent
# =============================================================================


"""Some constants for graphical settings"""
lw = 3
ticksize_major = 8
ticksize_minor = 8  
    
"""Prepare plots"""
fig = plt.figure(0)
fig.set_size_inches(8.5,8)
fig.set_tight_layout(True)
ax = plt.gca()
ax.set_xlabel('Current Density [$\mathregular{mA/cm^2}$]')
ax.set_ylabel('EQE [%]')

"""Plot the data"""
file_path = os.path.join(data_folder_path,'dyrvik_00272c_AB_3_0.ilv_processed')
df = pd.read_csv(file_path)
ax.semilogx(df['LED current [mA/cm2]'], df['EQE [%]'], color=COLOURS_GREENS[900])
    
"""Axis settings"""
ax.set_xlim(left=2e-3)
ax.yaxis.set_minor_locator(mpl.ticker.MultipleLocator(1))
ax.yaxis.set_major_locator(mpl.ticker.MultipleLocator(2))
ax.xaxis.set_major_locator(mpl.ticker.LogLocator(base=10))

"""Annotation"""
ax.annotate('15.0%',
            xy=(3.23e-1, 14.98), xycoords='data',
            xytext=(20, -100), textcoords='offset points',
            arrowprops=dict(facecolor='black', width=lw),
            horizontalalignment='right', verticalalignment='bottom')

"""Graphical details"""
plt.rcParams['font.size'] = 24
plt.rcParams['axes.linewidth'] = lw
plt.rcParams['lines.linewidth'] = lw*1.5

ax.xaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.xaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)
ax.yaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.yaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)

"""Exporting plots"""
export_name = 'Plot'
plot_name = ' Record 15.0 percent'
export_name_pdf = export_name + plot_name + '.pdf'
export_name_svg = export_name + plot_name + '.svg'
pdf_path = os.path.join(export_folder_path,export_name_pdf)
svg_path = os.path.join(export_folder_path,export_name_svg)
if len(pdf_path) > 255:
    warning_string = 'Warning: plot file path longer than 255 characters, downstream handling issues may occur. Path: ' + pdf_path
    print(warning_string)
fig.savefig(pdf_path)
fig.savefig(svg_path)
plt.close(fig)
